#!/bin/sh

MASTER_PAGE_SC_NETWORK_CONF_RESULT_MSG=""
MASTER_PAGE_SC_NETWORK_CONF_RESULT_OK=0
MASTER_PAGE_SC_NETWORK_CONF_RESULT_ERROR=1

MASTER_PAGE_SC_NETWORK_CONF_RESULT_CODE=${MASTER_PAGE_SC_NETWORK_CONF_RESULT_ERROR}
MASTER_PAGE_SC_NETWORK_CONF_RESULT_ROLLING=0

master_page_sc_network_conf() {
    debug_print "${0}" "${LINENO}" 'in function "master_page_sc_network_conf"'

    # assign default value
    [ -z "${RT_SC_IP}" ]      && RT_SC_IP="${conf_sc_ip}"
    [ -z "${RT_SC_NETMASK}" ] && RT_SC_NETMASK="${conf_sc_netmask}"
    [ -z "${RT_SC_DNS}" ]     && RT_SC_DNS="${conf_sc_dns}"
    [ -z "${RT_SC_GATEWAY}" ] && RT_SC_GATEWAY="${conf_sc_gateway}"
    
    
	tp_network_conf \
		"${MASTER_PAGE_SC_NETWORK_CONF_TITLE}" \
		"${MASTER_PAGE_SC_NETWORK_CONF_TEXT}" \
		"${MASTER_PAGE_SC_NETWORK_CONF_LABEL_OK}" \
		"${MASTER_PAGE_SC_NETWORK_CONF_LABEL_CANCEL}" \
        "${RT_SC_IP}" \
        "${RT_SC_NETMASK}" \
        "${RT_SC_GATEWAY}" \
        "${RT_SC_DNS}"    
        
        
    debug_print "${0}" "${LINENO}" "TP_NETWORK_CONF_RESULT_CODE: ${TP_NETWORK_CONF_RESULT_CODE}"
    case "${TP_NETWORK_CONF_RESULT_CODE}" in
    
        "${TP_NETWORK_CONF_RESULT_ERROR}")
            MASTER_PAGE_SC_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_SC_NETWORK_CONF_RESULT_ERROR
            MASTER_PAGE_SC_NETWORK_CONF_RESULT_ROLLING=0
            MASTER_PAGE_SC_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_RESULT_MSG}"
            return
            ;;
        
        "${TP_NETWORK_CONF_RESULT_CANCEL}")
            MASTER_PAGE_SC_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_SC_NETWORK_CONF_RESULT_OK
            MASTER_PAGE_SC_NETWORK_CONF_RESULT_ROLLING=-1
            MASTER_PAGE_SC_NETWORK_CONF_RESULT_MSG=""
            return
            ;;
            
        "${TP_NETWORK_CONF_RESULT_OK}" )
            ;;
        
        *)
            MASTER_PAGE_SC_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_SC_NETWORK_CONF_RESULT_ERROR
            MASTER_PAGE_SC_NETWORK_CONF_RESULT_ROLLING=0
            MASTER_PAGE_SC_NETWORK_CONF_RESULT_MSG="${MASTER_PAGE_SC_NETWORK_CONF_ERROR_UNKNOWN}"
            return
            ;;
    esac
	
    # apply and error handling
    utility_apply_sc_network_conf \
        "${RT_SC_DHCP}" \
        "${TP_NETWORK_CONF_RESULT_IP}" \
        "${TP_NETWORK_CONF_RESULT_NETMASK}" \
        "${TP_NETWORK_CONF_RESULT_GATEWAY}" \
        "${TP_NETWORK_CONF_RESULT_DNS}"
    if [ "${?}" -ne 0 ]; then
        MASTER_PAGE_SC_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_SC_NETWORK_CONF_RESULT_ERROR
        MASTER_PAGE_SC_NETWORK_CONF_RESULT_ROLLING=0
        MASTER_PAGE_SC_NETWORK_CONF_RESULT_MSG="${MASTER_PAGE_SC_NETWORK_CONF_ERROR_APPLY_NETWORK_CONF}: ${UTILITY_APPLY_SC_NETWORK_CONF_RESULT_MSG}"
        return
    fi
	
    # save to database
    RT_SC_IP="${UTILITY_APPLY_SC_NETWORK_CONF_RESULT_IP}"
    RT_SC_NETMASK="${UTILITY_APPLY_SC_NETWORK_CONF_RESULT_NETMASK}"
    RT_SC_DNS="${UTILITY_APPLY_SC_NETWORK_CONF_RESULT_DNS}"
    RT_SC_GATEWAY="${UTILITY_APPLY_SC_NETWORK_CONF_RESULT_GATEWAY}"
    utility_save_sc_network_conf \
        "${RT_SC_DHCP}" \
        "${RT_SC_IP}" \
        "${RT_SC_NETMASK}" \
        "${RT_SC_GATEWAY}" \
        "${RT_SC_DNS}"
    if [ "${?}" -ne 0 ]; then
        MASTER_PAGE_SC_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_SC_NETWORK_CONF_RESULT_ERROR
        MASTER_PAGE_SC_NETWORK_CONF_RESULT_ROLLING=0
        MASTER_PAGE_SC_NETWORK_CONF_RESULT_MSG="${MASTER_PAGE_SC_NETWORK_CONF_ERROR_SAVE_CONFIGURATION}: ${UTILITY_SAVE_SC_NETWORK_CONF_RESULT_MSG}"
        return
    fi
	
    MASTER_PAGE_SC_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_SC_NETWORK_CONF_RESULT_OK
    MASTER_PAGE_SC_NETWORK_CONF_RESULT_ROLLING=1
    MASTER_PAGE_SC_NETWORK_CONF_RESULT_MSG=""
}